/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import processing.app.Base;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.syntax.SyntaxStyle;
import processing.core.PApplet;

public class Preferences {
    static final String PREFS_FILE = "preferences.txt";
    String[] languages = new String[]{I18n._("System Default"), "\u0627\u0644\u0639\u0631\u0628\u064a\u0629 (" + I18n._("Arabic") + ")", "Aragon\u00e9s (" + I18n._("Aragonese") + ")", "Catal\u00e0 (" + I18n._("Catalan") + ")", "\u7b80\u4f53\u4e2d\u6587 (" + I18n._("Chinese Simplified") + ")", "\u7e41\u9ad4\u4e2d\u6587 (" + I18n._("Chinese Traditional") + ")", "Dansk (" + I18n._("Danish") + ")", "Nederlands (" + I18n._("Dutch") + ")", "English (" + I18n._("English") + ")", "Eesti (" + I18n._("Estonian") + ")", "Pilipino (" + I18n._("Filipino") + ")", "Fran\u00e7ais (" + I18n._("French") + ")", "Galego (" + I18n._("Galician") + ")", "Deutsch (" + I18n._("German") + ")", "\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac (" + I18n._("Greek") + ")", "Magyar (" + I18n._("Hindi") + ")", "Magyar (" + I18n._("Hungarian") + ")", "Bahasa Indonesia (" + I18n._("Indonesian") + ")", "Italiano (" + I18n._("Italian") + ")", "\u65e5\u672c\u8a9e (" + I18n._("Japanese") + ")", "\ud55c\uad6d\uc5b4 (" + I18n._("Korean") + ")", "Latvie\u0161u (" + I18n._("Latvian") + ")", "Lietuvi\u0173 Kalba (" + I18n._("Lithuaninan") + ")", "\u092e\u0930\u093e\u0920\u0940 (" + I18n._("Marathi") + ")", "Norsk (" + I18n._("Norwegian") + ")", "\u0641\u0627\u0631\u0633\u06cc (" + I18n._("Persian") + ")", "J\u0119zyk Polski (" + I18n._("Polish") + ")", "Portugu\u00eas (" + I18n._("Portuguese") + " - Brazil)", "Portugu\u00eas (" + I18n._("Portuguese") + " - Portugal)", "Rom\u00e2n\u0103 (" + I18n._("Romanian") + ")", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439 (" + I18n._("Russian") + ")", "Espa\u00f1ol (" + I18n._("Spanish") + ")", "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd (" + I18n._("Tamil") + ")"};
    String[] languagesISO = new String[]{"", "ar", "an", "ca", "zh_cn", "zh_tw", "da", "nl", "en", "et", "tl", "fr", "gl", "de", "el", "hi", "hu", "id", "it", "ja", "ko", "lv", "lt", "mr", "no_nb", "fa", "pl", "pt_br", "pt_pt", "ro", "ru", "es", "ta"};
    public static int BUTTON_WIDTH = 80;
    public static int BUTTON_HEIGHT = 24;
    static final int GRID_SIZE = 33;
    static final int GUI_BIG = 13;
    static final int GUI_BETWEEN = 10;
    static final int GUI_SMALL = 6;
    JFrame dialog = new JFrame(I18n._("Preferences"));
    int wide;
    int high;
    JTextField sketchbookLocationField;
    JCheckBox exportSeparateBox;
    JCheckBox verboseCompilationBox;
    JCheckBox verboseUploadBox;
    JCheckBox displayLineNumbersBox;
    JCheckBox verifyUploadBox;
    JCheckBox externalEditorBox;
    JCheckBox memoryOverrideBox;
    JTextField memoryField;
    JCheckBox checkUpdatesBox;
    JTextField fontSizeField;
    JCheckBox updateExtensionBox;
    JCheckBox autoAssociateBox;
    JComboBox comboLanguage;
    Editor editor;
    static Hashtable defaults;
    static Hashtable table;
    static File preferencesFile;

    protected static void init(String commandLinePrefs) {
        try {
            Preferences.load(Base.getLibStream(PREFS_FILE));
        }
        catch (Exception e) {
            Base.showError(null, I18n._("Could not read default settings.\nYou'll need to reinstall Arduino."), e);
        }
        String platformExt = "." + Base.platform.getName();
        int platformExtLength = platformExt.length();
        Enumeration e = table.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.endsWith(platformExt)) continue;
            String actualKey = key.substring(0, key.length() - platformExtLength);
            String value = Preferences.get(key);
            table.put(actualKey, value);
        }
        defaults = (Hashtable)table.clone();
        if (commandLinePrefs != null) {
            try {
                Preferences.load(new FileInputStream(commandLinePrefs));
            }
            catch (Exception poe) {
                Base.showError(I18n._("Error"), I18n.format(I18n._("Could not read preferences from {0}"), commandLinePrefs), poe);
            }
        } else if (!Base.isCommandLine()) {
            preferencesFile = Base.getSettingsFile(PREFS_FILE);
            if (!preferencesFile.exists()) {
                Preferences.save();
            } else {
                try {
                    Preferences.load(new FileInputStream(preferencesFile));
                }
                catch (Exception ex) {
                    Base.showError(I18n._("Error reading preferences"), I18n.format(I18n._("Error reading the preferences file. Please delete (or move)\n{0} and restart Arduino."), preferencesFile.getAbsolutePath()), ex);
                }
            }
        }
        I18n.init(Preferences.get("editor.languages.current"));
        Preferences.setColor("run.window.bgcolor", SystemColor.control);
    }

    public Preferences() {
        this.dialog.setResizable(false);
        Container pain = this.dialog.getContentPane();
        pain.setLayout(null);
        int top = 13;
        int left = 13;
        int right = 0;
        JLabel label = new JLabel(I18n._("Sketchbook location:"));
        pain.add(label);
        Dimension d = label.getPreferredSize();
        label.setBounds(left, top, d.width, d.height);
        top += d.height;
        this.sketchbookLocationField = new JTextField(40);
        pain.add(this.sketchbookLocationField);
        d = this.sketchbookLocationField.getPreferredSize();
        JButton button = new JButton(I18n.PROMPT_BROWSE);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File dflt = new File(Preferences.this.sketchbookLocationField.getText());
                File file = Base.selectFolder(I18n._("Select new sketchbook location"), dflt, Preferences.this.dialog);
                if (file != null) {
                    Preferences.this.sketchbookLocationField.setText(file.getAbsolutePath());
                }
            }
        });
        pain.add(button);
        Dimension d2 = button.getPreferredSize();
        int vmax = Math.max(d.height, d2.height);
        this.sketchbookLocationField.setBounds(left, top + (vmax - d.height) / 2, d.width, d.height);
        int h = left + d.width + 6;
        button.setBounds(h, top + (vmax - d2.height) / 2, d2.width, d2.height);
        right = Math.max(right, h + d2.width + 13);
        top += vmax + 10;
        Box box = Box.createHorizontalBox();
        label = new JLabel(I18n._("Editor language: "));
        box.add(label);
        this.comboLanguage = new JComboBox<String>(this.languages);
        this.comboLanguage.setSelectedIndex(Arrays.asList(this.languagesISO).indexOf(Preferences.get("editor.languages.current")));
        box.add(this.comboLanguage);
        label = new JLabel(I18n._("  (requires restart of Arduino)"));
        box.add(label);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        ((Component)box).setForeground(Color.gray);
        box.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        box = Box.createHorizontalBox();
        label = new JLabel(I18n._("Editor font size: "));
        box.add(label);
        this.fontSizeField = new JTextField(4);
        box.add(this.fontSizeField);
        label = new JLabel(I18n._("  (requires restart of Arduino)"));
        box.add(label);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        box.setBounds(left, top, d.width, d.height);
        Font editorFont = Preferences.getFont("editor.font");
        this.fontSizeField.setText(String.valueOf(editorFont.getSize()));
        top += d.height + 10;
        box = Box.createHorizontalBox();
        label = new JLabel(I18n._("Show verbose output during: "));
        box.add(label);
        this.verboseCompilationBox = new JCheckBox(I18n._("compilation "));
        box.add(this.verboseCompilationBox);
        this.verboseUploadBox = new JCheckBox(I18n._("upload"));
        box.add(this.verboseUploadBox);
        pain.add(box);
        d = ((Container)box).getPreferredSize();
        box.setBounds(left, top, d.width, d.height);
        this.displayLineNumbersBox = new JCheckBox(I18n._("Display line numbers"));
        pain.add(this.displayLineNumbersBox);
        d = this.displayLineNumbersBox.getPreferredSize();
        this.displayLineNumbersBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.verifyUploadBox = new JCheckBox(I18n._("Verify code after upload"));
        pain.add(this.verifyUploadBox);
        d = this.verifyUploadBox.getPreferredSize();
        this.verifyUploadBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.externalEditorBox = new JCheckBox(I18n._("Use external editor"));
        pain.add(this.externalEditorBox);
        d = this.externalEditorBox.getPreferredSize();
        this.externalEditorBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.checkUpdatesBox = new JCheckBox(I18n._("Check for updates on startup"));
        pain.add(this.checkUpdatesBox);
        d = this.checkUpdatesBox.getPreferredSize();
        this.checkUpdatesBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        this.updateExtensionBox = new JCheckBox(I18n._("Update sketch files to new extension on save (.pde -> .ino)"));
        pain.add(this.updateExtensionBox);
        d = this.updateExtensionBox.getPreferredSize();
        this.updateExtensionBox.setBounds(left, top += d.height + 10, d.width + 10, d.height);
        right = Math.max(right, left + d.width);
        top += d.height + 10;
        if (Base.isWindows()) {
            this.autoAssociateBox = new JCheckBox(I18n._("Automatically associate .ino files with Arduino"));
            pain.add(this.autoAssociateBox);
            d = this.autoAssociateBox.getPreferredSize();
            this.autoAssociateBox.setBounds(left, top, d.width + 10, d.height);
            right = Math.max(right, left + d.width);
            top += d.height + 10;
        }
        label = new JLabel(I18n._("More preferences can be edited directly in the file"));
        pain.add(label);
        d = label.getPreferredSize();
        label.setForeground(Color.gray);
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        final JLabel clickable = label = new JLabel(preferencesFile.getAbsolutePath());
        label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Base.openFolder(Base.getSettingsFolder());
            }

            public void mouseEntered(MouseEvent e) {
                clickable.setForeground(new Color(0, 0, 140));
            }

            public void mouseExited(MouseEvent e) {
                clickable.setForeground(Color.BLACK);
            }
        });
        pain.add(label);
        d = label.getPreferredSize();
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        label = new JLabel(I18n._("(edit only when Arduino is not running)"));
        pain.add(label);
        d = label.getPreferredSize();
        label.setForeground(Color.gray);
        label.setBounds(left, top, d.width, d.height);
        right = Math.max(right, left + d.width);
        top += d.height;
        button = new JButton(I18n.PROMPT_OK);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences.this.applyFrame();
                Preferences.this.disposeFrame();
            }
        });
        pain.add(button);
        d2 = button.getPreferredSize();
        BUTTON_HEIGHT = d2.height;
        h = right - (BUTTON_WIDTH + 6 + BUTTON_WIDTH);
        button.setBounds(h, top, BUTTON_WIDTH, BUTTON_HEIGHT);
        button = new JButton(I18n.PROMPT_CANCEL);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Preferences.this.disposeFrame();
            }
        });
        pain.add(button);
        button.setBounds(h += BUTTON_WIDTH + 6, top, BUTTON_WIDTH, BUTTON_HEIGHT);
        this.wide = right + 13;
        this.high = (top += BUTTON_HEIGHT + 10) + 6;
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Preferences.this.disposeFrame();
            }
        });
        ActionListener disposer = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Preferences.this.disposeFrame();
            }
        };
        Base.registerWindowCloseKeys(this.dialog.getRootPane(), disposer);
        Base.setIcon(this.dialog);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.dialog.setLocation((screen.width - this.wide) / 2, (screen.height - this.high) / 2);
        this.dialog.pack();
        Insets insets = this.dialog.getInsets();
        this.dialog.setSize(this.wide + insets.left + insets.right, this.high + insets.top + insets.bottom);
        pain.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                KeyStroke wc = Editor.WINDOW_CLOSE_KEYSTROKE;
                if (e.getKeyCode() == 27 || KeyStroke.getKeyStrokeForEvent(e).equals(wc)) {
                    Preferences.this.disposeFrame();
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.wide, this.high);
    }

    protected void disposeFrame() {
        this.dialog.dispose();
    }

    protected void applyFrame() {
        Preferences.setBoolean("build.verbose", this.verboseCompilationBox.isSelected());
        Preferences.setBoolean("upload.verbose", this.verboseUploadBox.isSelected());
        Preferences.setBoolean("editor.linenumbers", this.displayLineNumbersBox.isSelected());
        Preferences.setBoolean("upload.verify", this.verifyUploadBox.isSelected());
        String oldPath = Preferences.get("sketchbook.path");
        String newPath = this.sketchbookLocationField.getText();
        if (!newPath.equals(oldPath)) {
            this.editor.base.rebuildSketchbookMenus();
            Preferences.set("sketchbook.path", newPath);
        }
        Preferences.setBoolean("editor.external", this.externalEditorBox.isSelected());
        Preferences.setBoolean("update.check", this.checkUpdatesBox.isSelected());
        String newSizeText = this.fontSizeField.getText();
        try {
            int newSize = Integer.parseInt(newSizeText.trim());
            String[] pieces = PApplet.split((String)Preferences.get("editor.font"), (char)',');
            pieces[2] = String.valueOf(newSize);
            Preferences.set("editor.font", PApplet.join((String[])pieces, (char)','));
        }
        catch (Exception e) {
            System.err.println(I18n.format(I18n._("ignoring invalid font size {0}"), newSizeText));
        }
        if (this.autoAssociateBox != null) {
            Preferences.setBoolean("platform.auto_file_type_associations", this.autoAssociateBox.isSelected());
        }
        Preferences.setBoolean("editor.update_extension", this.updateExtensionBox.isSelected());
        Object newItem = this.comboLanguage.getSelectedItem();
        int pos = Arrays.asList(this.languages).indexOf(newItem.toString());
        Preferences.set("editor.languages.current", Arrays.asList(this.languagesISO).get(pos));
        this.editor.applyPreferences();
    }

    protected void showFrame(Editor editor) {
        this.editor = editor;
        this.verboseCompilationBox.setSelected(Preferences.getBoolean("build.verbose"));
        this.verboseUploadBox.setSelected(Preferences.getBoolean("upload.verbose"));
        this.displayLineNumbersBox.setSelected(Preferences.getBoolean("editor.linenumbers"));
        this.verifyUploadBox.setSelected(Preferences.getBoolean("upload.verify"));
        this.sketchbookLocationField.setText(Preferences.get("sketchbook.path"));
        this.externalEditorBox.setSelected(Preferences.getBoolean("editor.external"));
        this.checkUpdatesBox.setSelected(Preferences.getBoolean("update.check"));
        if (this.autoAssociateBox != null) {
            this.autoAssociateBox.setSelected(Preferences.getBoolean("platform.auto_file_type_associations"));
        }
        this.updateExtensionBox.setSelected(Preferences.get("editor.update_extension") == null || Preferences.getBoolean("editor.update_extension"));
        this.dialog.setVisible(true);
    }

    protected static void load(InputStream input) throws IOException {
        Preferences.load(input, table);
    }

    public static void load(InputStream input, Map table) throws IOException {
        String[] lines;
        for (String line : lines = Preferences.loadStrings(input)) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, equals).trim();
            String value = line.substring(equals + 1).trim();
            table.put(key, value);
        }
    }

    public static String[] loadStrings(InputStream input) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(input, "UTF-8"));
            String[] lines = new String[100];
            int lineCount = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (lineCount == lines.length) {
                    String[] temp = new String[lineCount << 1];
                    System.arraycopy(lines, 0, temp, 0, lineCount);
                    lines = temp;
                }
                lines[lineCount++] = line;
            }
            reader.close();
            if (lineCount == lines.length) {
                return lines;
            }
            String[] output = new String[lineCount];
            System.arraycopy(lines, 0, output, 0, lineCount);
            return output;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static void save() {
        if (preferencesFile == null) {
            return;
        }
        PrintWriter writer = PApplet.createWriter((File)preferencesFile);
        Object[] keys = table.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        for (Object key : keys) {
            writer.println((String)key + "=" + (String)table.get(key));
        }
        writer.flush();
        writer.close();
    }

    public static String get(String attribute) {
        return (String)table.get(attribute);
    }

    public static String getDefault(String attribute) {
        return (String)defaults.get(attribute);
    }

    public static void set(String attribute, String value) {
        table.put(attribute, value);
    }

    public static void unset(String attribute) {
        table.remove(attribute);
    }

    public static boolean getBoolean(String attribute) {
        String value = Preferences.get(attribute);
        return new Boolean(value);
    }

    public static void setBoolean(String attribute, boolean value) {
        Preferences.set(attribute, value ? "true" : "false");
    }

    public static int getInteger(String attribute) {
        return Integer.parseInt(Preferences.get(attribute));
    }

    public static void setInteger(String key, int value) {
        Preferences.set(key, String.valueOf(value));
    }

    public static Color getColor(String name) {
        Color parsed = Color.GRAY;
        String s = Preferences.get(name);
        if (s != null && s.indexOf("#") == 0) {
            try {
                parsed = new Color(Integer.parseInt(s.substring(1), 16));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return parsed;
    }

    public static void setColor(String attr, Color what) {
        Preferences.set(attr, "#" + PApplet.hex((int)(what.getRGB() & 0xFFFFFF), (int)6));
    }

    public static Font getFont(String attr) {
        String[] pieces;
        boolean replace = false;
        String value = Preferences.get(attr);
        if (value == null) {
            value = Preferences.getDefault(attr);
            replace = true;
        }
        if ((pieces = PApplet.split((String)value, (char)',')).length != 3) {
            value = Preferences.getDefault(attr);
            pieces = PApplet.split((String)value, (char)',');
            replace = true;
        }
        String name = pieces[0];
        int style = 0;
        if (pieces[1].indexOf("bold") != -1) {
            style |= 1;
        }
        if (pieces[1].indexOf("italic") != -1) {
            style |= 2;
        }
        int size = PApplet.parseInt((String)pieces[2], (int)12);
        Font font = new Font(name, style, size);
        if (replace) {
            Preferences.set(attr, value);
        }
        return font;
    }

    public static SyntaxStyle getStyle(String what) {
        String str = Preferences.get("editor." + what + ".style");
        StringTokenizer st = new StringTokenizer(str, ",");
        String s = st.nextToken();
        if (s.indexOf("#") == 0) {
            s = s.substring(1);
        }
        Color color = Color.DARK_GRAY;
        try {
            color = new Color(Integer.parseInt(s, 16));
        }
        catch (Exception e) {
            // empty catch block
        }
        s = st.nextToken();
        boolean bold = s.indexOf("bold") != -1;
        boolean italic = s.indexOf("italic") != -1;
        boolean underlined = s.indexOf("underlined") != -1;
        return new SyntaxStyle(color, italic, bold, underlined);
    }

    static {
        table = new Hashtable();
    }
}

